<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


class orsoAPI
{

	PRIVATE CONST ORSO_URL = 'https://api.cielo.net.au';

	PRIVATE CONST ORSO_PHP_CLASS_VERSION = '0.0.2';

	private $token = null;

	public function __construct($token){
		$this->token = $token;
	}


	private function getHeaders(){

		$headers = array("User-Agent: ORSO PHP CLASS " . SELF::ORSO_PHP_CLASS_VERSION);


		return $headers;

	}

	private function checkResponseOfCurl($curl)
	{


		$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

		switch($httpcode){
			case '200':
				return; //All Good. Nothing to do
			case '403':
				Throw New Exception("Invalid Token");
				break;
			case '404':
				Throw New Exception("Invalid Command");
				break;
			default:
				Throw New Exception("Unknow Error");
				break;				
		}

	}


	public function appaCategory(){


		$url = SELF::ORSO_URL . '?token=' . $this->token . '&command=appaCategories';

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);

		$this->checkResponseOfCurl($curl);

		return json_decode($response);

	}

	



	public function appaProducts(int $appaCategory){



		$url = 
			SELF::ORSO_URL . 
				'?token=' . $this->token . 
				'&command=products' .
				'&Limit=250&appaCategory[]=' . $appaCategory ;


		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);


		$this->checkResponseOfCurl($curl);

		return json_decode($response);

	}






	public function categories(){


		$url = SELF::ORSO_URL . '?token=' . $this->token . '&command=categories';

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);

		$this->checkResponseOfCurl($curl);

		return json_decode($response);

	}



	public function deletedProducts(DateTime $dateModified){


		$dateModified = $dateModified->format("Y/m/d%20H:i:s");


		$url = 
			SELF::ORSO_URL . 
				'?token=' . $this->token . 
				'&command=deletedProducts' . 
				'&deleted_on=' . $dateModified .
				'&Limit=250';

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);


		$this->checkResponseOfCurl($curl);

		return json_decode($response);

	}


	public function getLatestProducts(DateTime $dateModified = null){

		$url = 
			SELF::ORSO_URL . 
				'?token=' . $this->token . 
				'&command=Products'.
				'&posted=Y' ;

		if($dateModified){
			$dateModified = $dateModified->format("Y/m/d%20H:i:s");
			$url .= '&updated_at=' . $dateModified ;
		}

		$url .=  '&sort=updated_at&limit=250';
				

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);


		$this->checkResponseOfCurl($curl);

		return json_decode($response);

	}


	public function getNewProducts(DateTime $dateAdded = null){

		$url = 
			SELF::ORSO_URL . 
				'?token=' . $this->token . 
				'&command=Products'.
				'&posted=Y' ;

		if($dateAdded){
			$dateAdded = $dateAdded->format("Y/m/d%20H:i:s");
			$url .= '&created_at=' . $dateAdded ;
		}

		$url .=  '&sort=created_at&limit=250';
				

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);


		$this->checkResponseOfCurl($curl);

		return json_decode($response);



	}


	public function getBaseProducts(){


		$url = 
			SELF::ORSO_URL . 
				'?token=' . $this->token . 
				'&command=baseproducts'.
				'&posted=Y' ;

		$url .=  '&sort=created_at&limit=10';
				

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);


		$this->checkResponseOfCurl($curl);

		return json_decode($response);


	}


	public function productByCategory($categoryId){


		$url = 
			SELF::ORSO_URL . 
				'?token=' . $this->token . 
				'&command=products'.
				'&posted=Y'.
				'&category=' . $categoryId;
				

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);


		$this->checkResponseOfCurl($curl);

		return json_decode($response);


	}	

	public function productBySku($sku){


		$url = 
			SELF::ORSO_URL . 
				'?token=' . $this->token . 
				'&command=products'.
				'&posted=Y'.
				'&sku=' . $sku;
				

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);


		$this->checkResponseOfCurl($curl);

		return json_decode($response);


	}

	public function productBySkus(array $skus){


		$url = 
			SELF::ORSO_URL . 
				'?token=' . $this->token . 
				'&command=products'.
				'&posted=Y';


		foreach($skus as $sku){
			$url .= '&sku[]=' . $sku;
		}
			
		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => $this->getHeaders()
		));

		$response = curl_exec($curl);

		$this->checkResponseOfCurl($curl);

		$json = json_decode($response);

		return $json; 

	}

	public function getAllProducts(){

		// This function is currently set to only loop 5 times getting 10 products per time
		// Notes below to change the limit value and remove the 5 loop limit

		$idSearch = 0;

		$count = 0;

		$countLimit = 5; // This is the number of times you want to loop through, change to 999999 to get all products

		$limit = 10; // you can change this to max of 250

		$products = [];

		do{
			$count++;

			$url = 
				SELF::ORSO_URL . 
					'?token=' . $this->token . 
					'&command=Products'.
					'&posted=Y' ;

			$url .=  '&sort=entity_id&limit='.$limit.'&id='.$idSearch;
					

			$curl = curl_init();

			curl_setopt_array($curl, array(
			  CURLOPT_URL => $url,
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			  CURLOPT_HTTPHEADER => $this->getHeaders()
			));

			$response = curl_exec($curl);


			$this->checkResponseOfCurl($curl);

			$response = json_decode($response, true);

			foreach($response as $product){


				$idSearch = max($idSearch, intval($product['entity_id']) );

			}

			$products = array_merge($products, $response);

			if( $count == $countLimit)
			{

				return $products;
			}

		}while( count($response) == $limit);

	}


}

$token = 'YourTokenHere';


$orsoAPI = new orsoAPI($token);


//$data = $orsoAPI->appaCategory();

//$data = $orsoAPI->getAllProducts(); 


//$data = $orsoAPI->appaProducts(197); 


//$data = $orsoAPI->deletedProducts(New DateTime('2010-01-01'));

//$data = $orsoAPI->getLatestProducts();

//$data = $orsoAPI->getNewProducts();

//$data = $orsoAPI->productBySku('G1038');

//$data = $orsoAPI->productByCategory('51');

//$data = $orsoAPI->productBySkus(['G1038','G772','G1686']);

$data = $orsoAPI->getBaseProducts(); 


echo("<pre>"); print_r($data); echo("</pre>");